/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemEntityInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketCrafterFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketItemInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemPartInteractable
extends AItemPart
implements IItemEntityInteractable {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("interactable");
        }

        @Override
        public ItemPartInteractable createItem(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
            return new ItemPartInteractable(definition, subDefinition, sourcePackID);
        }
    };

    public ItemPartInteractable(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subDefinition, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).interactable.inventoryUnits && placementDefinition.maxValue >= ((JSONPart)this.definition).interactable.inventoryUnits);
    }

    @Override
    public PartInteractable createPart(AEntityF_Multipart<?> entity, IWrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, IWrapperNBT partData) {
        return new PartInteractable(entity, placingPlayer, packVehicleDef, this, partData);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (((JSONPart)this.definition).interactable.interactionType) {
            case CRATE: {
                tooltipLines.add(LanguageSystem.ITEMINFO_INTERACTABLE_CAPACITY.getCurrentValue() + ((JSONPart)this.definition).interactable.inventoryUnits * 9.0f);
                break;
            }
            case BARREL: {
                tooltipLines.add(LanguageSystem.ITEMINFO_INTERACTABLE_CAPACITY.getCurrentValue() + ((JSONPart)this.definition).interactable.inventoryUnits * 10000.0f + "mb");
                IWrapperNBT tankData = data.getData("tank");
                if (tankData == null) break;
                String tankFluidName = tankData.getString("currentFluid");
                double tankFluidLevel = tankData.getDouble("fluidLevel");
                if (tankFluidLevel == 0.0) break;
                tooltipLines.add(LanguageSystem.ITEMINFO_INTERACTABLE_CONTENTS.getCurrentValue() + tankFluidName + ":" + tankFluidLevel + "mb");
                break;
            }
            case JERRYCAN: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_FILL.getCurrentValue());
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_DRAIN.getCurrentValue());
                String jerrycanFluid = data.getString("jerrycanFluid");
                if (jerrycanFluid.isEmpty()) {
                    tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_EMPTY.getCurrentValue());
                    break;
                }
                tooltipLines.add(LanguageSystem.ITEMINFO_JERRYCAN_CONTAINS.getCurrentValue() + InterfaceManager.clientInterface.getFluidName(jerrycanFluid, "wildcard"));
                break;
            }
            case BATTERY: {
                tooltipLines.add(LanguageSystem.ITEMINFO_BATTERY_FILL.getCurrentValue());
                tooltipLines.add(LanguageSystem.ITEMINFO_BATTERY_DRAIN.getCurrentValue());
                if (data.getBoolean("batteryCharged")) {
                    tooltipLines.add(LanguageSystem.ITEMINFO_BATTERY_FULL.getCurrentValue());
                    break;
                }
                tooltipLines.add(LanguageSystem.ITEMINFO_BATTERY_EMPTY.getCurrentValue());
                break;
            }
        }
    }

    @Override
    public IItemEntityInteractable.CallbackType doEntityInteraction(AEntityE_Interactable<?> entity, BoundingBox hitBox, IWrapperPlayer player, boolean rightClick) {
        if (((JSONPart)this.definition).interactable.interactionType == JSONPart.InteractableComponentType.JERRYCAN) {
            if (!entity.world.isClient() && rightClick) {
                String jerrrycanFluid;
                IWrapperItemStack stack = player.getHeldStack();
                IWrapperNBT data = stack.getData();
                String string = jerrrycanFluid = data != null ? data.getString("jerrycanFluid") : "";
                if (entity instanceof PartInteractable) {
                    AEntityCrafter crafter;
                    EntityFluidTank tank = ((PartInteractable)entity).tank;
                    if (tank != null && jerrrycanFluid.isEmpty() && tank.getFluidLevel() >= 1000.0) {
                        if (data == null) {
                            data = InterfaceManager.coreInterface.getNewNBTWrapper();
                        }
                        data.setString("jerrycanFluid", tank.getFluid());
                        stack.setData(data);
                        tank.drain(1000.0, true);
                    }
                    if ((crafter = ((PartInteractable)entity).crafter) != null && !jerrrycanFluid.isEmpty()) {
                        if (ConfigSystem.settings.fuel.fuels.get(crafter.getFuelName()).containsKey(jerrrycanFluid)) {
                            int addedFuel = (int)(ConfigSystem.settings.fuel.fuels.get(crafter.getFuelName()).get(jerrrycanFluid) * 1000.0 * 20.0 * (double)crafter.definition.crafterEfficiency);
                            int priorFuel = crafter.ticksLeftOfFuel;
                            crafter.ticksLeftOfFuel = addedFuel;
                            InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterFuelAdd(crafter));
                            crafter.ticksLeftOfFuel += priorFuel;
                            crafter.ticksFuelProvides = crafter.ticksLeftOfFuel;
                            data.deleteEntry("jerrycanFluid");
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_SUCCESS, new Object[0]));
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGTYPE, new Object[0]));
                        }
                    }
                } else if (!jerrrycanFluid.isEmpty()) {
                    if (entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
                        switch (vehicle.checkFuelTankCompatibility(jerrrycanFluid)) {
                            case VALID: {
                                if (vehicle.fuelTank.getFluidLevel() + 1000.0 > (double)vehicle.fuelTank.getMaxLevel()) {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_TOOFULL, new Object[0]));
                                    break;
                                }
                                vehicle.fuelTank.fill(jerrrycanFluid, "wildcard", 1000.0, true);
                                data.deleteEntry("jerrycanFluid");
                                stack.setData(data);
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_SUCCESS, new Object[0]));
                                break;
                            }
                            case INVALID: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGENGINES, new Object[0]));
                                break;
                            }
                            case MISMATCH: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_WRONGTYPE, new Object[0]));
                                break;
                            }
                            case NOENGINE: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_NOENGINE, new Object[0]));
                            }
                        }
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JERRYCAN_EMPTY, new Object[0]));
                }
            }
            return IItemEntityInteractable.CallbackType.NONE;
        }
        if (((JSONPart)this.definition).interactable.interactionType == JSONPart.InteractableComponentType.BATTERY) {
            if (!entity.world.isClient() && rightClick) {
                IWrapperItemStack stack = player.getHeldStack();
                IWrapperNBT data = stack.getData();
                boolean batteryCharged = data.getBoolean("batteryCharged");
                if (batteryCharged) {
                    if (entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)entity;
                        switch (vehicle.checkFuelTankCompatibility("electricity")) {
                            case VALID: {
                                if (vehicle.fuelTank.getFluidLevel() + 1000.0 > (double)vehicle.fuelTank.getMaxLevel()) {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_TOOFULL, new Object[0]));
                                    break;
                                }
                                vehicle.fuelTank.fill("electricity", "wildcard", 1000.0, true);
                                data.deleteEntry("batteryCharged");
                                stack.setData(data);
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_SUCCESS, new Object[0]));
                                break;
                            }
                            case INVALID: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_WRONGENGINES, new Object[0]));
                                break;
                            }
                            case MISMATCH: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_WRONGENGINES, new Object[0]));
                                break;
                            }
                            case NOENGINE: {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_NOENGINE, new Object[0]));
                            }
                        }
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_BATTERY_EMPTY, new Object[0]));
                }
            }
            return IItemEntityInteractable.CallbackType.NONE;
        }
        return IItemEntityInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onUsed(AWrapperWorld world, IWrapperPlayer player) {
        if (((JSONPart)this.definition).interactable.canBeOpenedInHand && ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) && player.isSneaking()) {
            if (!world.isClient()) {
                IWrapperNBT data = player.getHeldStack().getData();
                EntityInventoryContainer inventory = new EntityInventoryContainer(world, data != null ? data.getData("inventory") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f), ((JSONPart)this.definition).interactable.inventoryStackSize > 0 ? ((JSONPart)this.definition).interactable.inventoryStackSize : 64);
                world.addEntity(inventory);
                player.sendPacket(new PacketItemInteractable(player, inventory, this.subDefinition.inventoryTexture));
            }
            return true;
        }
        return false;
    }
}

